/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.servicetag;

import com.sun.star.servicetag.SystemEnvironment;
import java.io.File;
import java.util.HashSet;

class SolarisSystemEnvironment
extends SystemEnvironment {
    private static final int SN = 1;
    private static final int SYS = 2;
    private static final int CPU = 3;
    private static final int MODEL = 4;
    private String kstatCpuInfo = null;

    SolarisSystemEnvironment() {
        this.setHostId(this.getCommandOutput("/usr/bin/hostid"));
        this.setSystemModel(this.getSolarisModel());
        this.setSystemManufacturer(this.getSolarisSystemManufacturer());
        this.setCpuManufacturer(this.getSolarisCpuManufacturer());
        this.setSerialNumber(this.getSolarisSN());
        this.setPhysMem(this.getSolarisPhysMem());
        this.setSockets(this.getSolarisSockets());
        this.setCores(this.getSolarisCores());
        this.setVirtCpus(this.getSolarisVirtCpus());
        this.setCpuName(this.getSolarisCpuName());
        this.setClockRate(this.getSolarisClockRate());
    }

    private String getSolarisClockRate() {
        String string = this.getSolarisKstatCpuInfo();
        String[] stringArray = string.split("\n");
        String string2 = "clock_MHz";
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            if (!string3.startsWith(string2)) continue;
            return string3.substring(string3.indexOf(string2) + string2.length()).trim();
        }
        return "";
    }

    private String getSolarisCpuName() {
        String string = this.getSolarisKstatCpuInfo();
        String[] stringArray = string.split("\n");
        String string2 = "brand";
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            if (!string3.startsWith(string2)) continue;
            return string3.substring(string3.indexOf(string2) + string2.length()).trim();
        }
        return "";
    }

    private String getSolarisVirtCpus() {
        String string = this.getSolarisKstatCpuInfo();
        int n = 0;
        String[] stringArray = string.split("\n");
        String string2 = " cpu_info ";
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            if (string3.indexOf(string2) == -1) continue;
            ++n;
        }
        return "" + n;
    }

    private String getSolarisCores() {
        String string = this.getSolarisKstatCpuInfo();
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = string.split("\n");
        String string2 = "core_id";
        String string3 = "";
        String string4 = "chip_id";
        String string5 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String string6 = stringArray[i].trim();
            if (string6.startsWith(string4)) {
                string5 = string6.substring(string6.indexOf(string4) + string4.length()).trim();
            }
            if (!string6.startsWith(string2)) continue;
            string3 = string6.substring(string6.indexOf(string2) + string2.length()).trim();
            hashSet.add(string5 + "," + string3);
        }
        return "" + hashSet.size();
    }

    private String getSolarisPhysMem() {
        String string = this.getCommandOutput("/usr/sbin/prtconf");
        boolean bl = false;
        String[] stringArray = string.split("\n");
        String string2 = "Memory size:";
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            if (!string3.startsWith(string2) || (string3 = string3.substring(string3.indexOf(string2) + string2.length()).trim()).indexOf(" ") == -1) continue;
            return string3.substring(0, string3.indexOf(" ")).trim();
        }
        return "";
    }

    private String getSolarisSockets() {
        String string = this.getSolarisKstatCpuInfo();
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = string.split("\n");
        String string2 = "chip_id";
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            if (!string3.startsWith(string2)) continue;
            String string4 = string3.substring(string3.indexOf(string2) + string2.length()).trim();
            hashSet.add(string4);
        }
        return "" + hashSet.size();
    }

    private synchronized String getSolarisKstatCpuInfo() {
        if (this.kstatCpuInfo == null) {
            Thread thread = new Thread(){

                public void run() {
                    SolarisSystemEnvironment.this.kstatCpuInfo = SolarisSystemEnvironment.this.getCommandOutput("/usr/bin/kstat", "cpu_info");
                }
            };
            thread.start();
            try {
                thread.join(2000L);
                if (thread.isAlive()) {
                    thread.interrupt();
                    this.kstatCpuInfo = "";
                }
            }
            catch (InterruptedException interruptedException) {
                thread.interrupt();
            }
        }
        return this.kstatCpuInfo;
    }

    private String getSolarisModel() {
        Object object;
        String string = this.getFileContent("/var/run/psn");
        if (string.length() > 0 && 4 <= ((String[])(object = string.split("\n"))).length) {
            return object[3] + "::" + this.getCommandOutput("/usr/bin/uname", "-v");
        }
        if ("sparc".equalsIgnoreCase(System.getProperty("os.arch"))) {
            return this.getCommandOutput("/usr/bin/uname", "-i") + "::" + this.getCommandOutput("/usr/bin/uname", "-v");
        }
        object = this.getSmbiosData("1", "Product: ");
        if (object == null || ((String)object).trim().equals("")) {
            object = this.getCommandOutput("/usr/bin/uname", "-i");
        }
        if (object == null) {
            object = "";
        }
        return ((String)object).trim() + "::" + this.getCommandOutput("/usr/bin/uname", "-v");
    }

    private String getSolarisCpuManufacturer() {
        String[] stringArray;
        String string = this.getFileContent("/var/run/psn");
        if (string.length() > 0 && 3 <= (stringArray = string.split("\n")).length) {
            return stringArray[2];
        }
        if ("sparc".equalsIgnoreCase(System.getProperty("os.arch"))) {
            return "Sun Microsystems, Inc";
        }
        return this.getSmbiosData("4", "Manufacturer: ");
    }

    private String getSolarisSystemManufacturer() {
        String[] stringArray;
        String string = this.getFileContent("/var/run/psn");
        if (string.length() > 0 && 2 <= (stringArray = string.split("\n")).length) {
            return stringArray[1];
        }
        if ("sparc".equalsIgnoreCase(System.getProperty("os.arch"))) {
            if (this.getCommandOutput("/usr/bin/uname", "-m").equals("sun4us")) {
                return "Fujitsu";
            }
            return "Sun Microsystems, Inc";
        }
        return this.getSmbiosData("1", "Manufacturer: ");
    }

    private String getSolarisSN() {
        Object object;
        String string = this.getFileContent("/var/run/psn");
        if (string.length() > 0 && 1 <= ((String[])(object = string.split("\n"))).length) {
            return object[0];
        }
        object = this.getSneepSN();
        if (((String)object).length() > 0) {
            return object;
        }
        object = this.getSmbiosData("1", "Serial Number: ");
        if (((String)object).length() > 0) {
            return object;
        }
        object = this.getSmbiosData("3", "Serial Number: ");
        if (((String)object).length() > 0) {
            return object;
        }
        if ("sparc".equalsIgnoreCase(System.getProperty("os.arch"))) {
            object = this.getSNViaPrtfruX();
            if (((String)object).length() > 0) {
                return object;
            }
            object = this.getSNViaPrtfru();
            if (((String)object).length() > 0) {
                return object;
            }
        }
        return "";
    }

    private String getSmbiosData(String string, String string2) {
        String string3 = this.getCommandOutput("/usr/sbin/smbios", "-t", string);
        for (String string4 : string3.split("\n")) {
            String string5;
            String string6;
            int n;
            if (!string4.contains(string2) || (n = string4.indexOf(string2) + string2.length()) >= string4.length() || (string6 = (string5 = string4.substring(n).trim()).toLowerCase()).startsWith("not available") || string6.startsWith("to be filled by o.e.m")) continue;
            return string5;
        }
        return "";
    }

    private String getSneepSN() {
        String string = this.getCommandOutput("pkgparam", "SUNWsneep", "BASEDIR");
        File file = new File(string + "/bin/sneep");
        if (file.exists()) {
            String string2 = this.getCommandOutput(string + "/bin/sneep");
            if (string2.equalsIgnoreCase("unknown")) {
                return "";
            }
            return string2;
        }
        return "";
    }

    private String getSNViaPrtfruX() {
        String string = this.getCommandOutput("/usr/sbin/prtfru", "-x");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            int n;
            String string3 = stringArray[i];
            if (bl4 && (n = string3.indexOf(string2 = "<Sun_Serial_No value=\"")) != -1) {
                String string4 = string3.substring(n + string2.length());
                String[] stringArray2 = string4.split("\"");
                if (stringArray2.length <= 0) break;
                return stringArray2[0].trim();
            }
            if (string3.indexOf("</ContainerData>") != -1) {
                bl = false;
                bl2 = false;
                bl4 = false;
            }
            if (bl2 && string3.indexOf("<Container name=\"system-board\">") != -1) {
                bl4 = true;
            }
            if (bl && string3.indexOf("<Fru name=\"chassis\">") != -1) {
                bl2 = true;
            }
            if (string3.indexOf("<Location name=\"frutree\">") == -1) continue;
            bl = true;
        }
        return "";
    }

    private String getSNViaPrtfru() {
        String string = this.getCommandOutput("/usr/sbin/prtfru");
        boolean bl = false;
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            int n;
            String string3 = stringArray[i];
            if (bl && (n = string3.indexOf(string2 = "/ManR/Sun_Serial_No:")) != -1) {
                String string4 = string3.substring(n + string2.length());
                return string4.trim();
            }
            if (string3.indexOf("/frutree/chassis/system-board (container)") != -1) {
                bl = true;
                continue;
            }
            if (string3.indexOf("/frutree/chassis/MB?Label=MB/system-board (container)") == -1) continue;
            bl = true;
        }
        return "";
    }
}

